package w83b.w83bOperacionesPaso.w83bPreavisos;

import java.io.InputStream;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bClsTrazas;
import w83b.w83bUtilidadesComunes.W83bDateUtil;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bFichaPreavisoOriginalAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		//RECUPERAMOS PLANTILLA
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bFichaPreavisoOriginal.xls";
		InputStream inputStream = W83bFichaPreavisosAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        //RECUPERAMOS PREAVISO ORIGINAL
		W83bPreavisosBean preaviso=(W83bPreavisosBean)contexto.get("w83bPreavisoOriginal");
		
		//RECUPERAMOS PREAVISO NORMAL
		W83bPreavisosBean preavisoNormal=(W83bPreavisosBean)contexto.get("w83bPreavisosNuevoBeanTemp");
		
		//RECUPERAMOS DESCRIPCIONES DE CAMPOS
		String fichaDescConvenioOriginal = (String)contexto.get("fichaDescConvenioOriginal");
		String fichaDescProvinciaOriginal = (String)contexto.get("fichaDescProvinciaOriginal");
		String fichaDescMunicipioOriginal = (String)contexto.get("fichaDescMunicipioOriginal");
		
		HSSFHeader header = sheet.getHeader();//NOPMD
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());      
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));
        header.setRight(W83bDateUtil.getInstance().getLocaleStringFromDate(new Date(), idioma));
        
        
        //***************PIE DE DOCUMENTO********************//
        HSSFFooter footer = sheet.getFooter();//NOPMD
        footer.setCenter(((W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO)).getCalleListadosFormateada());
        footer.setRight(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.label.pag",idioma,new String[]{HSSFFooter.page()}));//NOPMD
      
        HSSFRow row ; 
        HSSFCell cell;
        
        //***************INICIO CABECERA DE DOCUMENTO********************//
        row = sheet.getRow((short)3); 
        cell = row.getCell((short)2);
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)2);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(tituloImagenEs.toString());
        //***************FIN CABECERA DE DOCUMENTO********************//
        
        row = sheet.getRow((short)8); // Creacin de la fila 1
        cell = row.getCell((short)1);

        
        //***************TITULO DE DOCUMENTO********************//
        row = sheet.getRow((short)8); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fichaPreOriginal",idioma));

        
        //***************INICIO DATOS BSICOS********************//
        row = sheet.getRow((short)10); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datosbasicos",idioma));
        
        //Linea num preaviso y centros afectados
        row = sheet.getRow((short)11); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numpreaviso",idioma)
        		+":  "+preaviso.getCodTerritorio()+"/"+preaviso.getAnyoPreaviso()+"/"+preaviso.getNumPreaviso());
        
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numcentros",idioma)
        		+":  "+(preaviso.getNum_centros_afectados()==null?"":preaviso.getNum_centros_afectados()));
        //***********************************************************      
     
        
        //Lnea fecha inicio  
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechinicioProcElectoral",idioma)
        		+":  "+(preaviso.getFecha_inicio()==null?"":preaviso.getFecha_inicio()));
        //***********************************************************         
      
        
        
        
        //fecha eleccin
        row = sheet.getRow((short)13); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fecheleccion",idioma)
        		+":  "+(preaviso.getFecha_eleccion()==null?"":preaviso.getFecha_eleccion()));
        //***********************************************************         
     
        
        
        //Lnea fecha registro y nmero registro
        String fechaRegistroES = "";
        String numRegistroES = "";
        if(!StringUtils.isEmpty(preaviso.getNumRegistroESPreavisoOriginal()) && !StringUtils.isEmpty(preaviso.getFechaRegistroESPreavisoOriginal())){
        	fechaRegistroES = preaviso.getFechaRegistroESPreavisoOriginal();
        	numRegistroES = preaviso.getNumRegistroESPreavisoOriginal();
        }else if(!StringUtils.isEmpty(preavisoNormal.getNum_registro()) && !StringUtils.isEmpty(preavisoNormal.getFecha_registro())){
        	fechaRegistroES = preavisoNormal.getFecha_registro();
        	numRegistroES = preavisoNormal.getNum_registro();
        }
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.numregistroes",idioma)
        		+":  "+numRegistroES);
       
        cell = row.getCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.fechregistroes",idioma)
        		+":  "+fechaRegistroES);
        //***********************************************************       
        
        //Lnea eleccin parcial y preaviso Global
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        String valor=null;
        if("S".equals(preaviso.getEleccion_parcial())){
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }else{
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();
        }
        String valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.eleccionparcial",idioma)+":  "+valor);//NOPMD

        cell = row.getCell((short)4); 
        if("S".equals(preaviso.getPreaviso_global())){
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else{
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.prevglobal",idioma)+":  "+valor);//NOPMD
        //***********************************************************        
        
        
        //Lnea administracin y empresa
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)1); 
        if("A".equals(preaviso.getAdmon())){
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else{
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.admon",idioma)
        		+":  "+valor);
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)4); 
        if("E".equals(preaviso.getAdmon())){
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }else{
        	valor = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma);
        }
        valor2 = W83bUtilidadesExcel.mayusculasCampoExcel(valor);
        valor = valor2;
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.empresa",idioma)+":  "+valor);//NOPMD
        //***********************************************************
        
        
        //Linea convenio
        row = sheet.getRow((short)17); 
        cell = row.getCell((short)1); 

        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.convenio",idioma)
        		+":  "+W83bUtilidadesExcel.mayusculasCampoExcel(fichaDescConvenioOriginal));
        int tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        //***********************************************************        
        
        //Observaciones
        row = sheet.getRow((short)18); 
        cell = row.getCell((short)1);
        String observaciones = preaviso.getObservaciones();
        if(StringUtils.isEmpty(observaciones)){
        	observaciones = "";
        }
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(observaciones);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.observaciones",idioma)
        		+":  "+valor);
        tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }                 
        //***********************************************************  

        //***************FIN DATOS BSICOS**************************//
        
        //***************INICIO PROMOTORES**************************//
        
        HSSFRow rowTemp = sheet.getRow((short)10);
        row = sheet.createRow((short)22); 
        cell = row.createCell((short)1);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.promotoreselec",idioma));
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        int numlinea=22;
        
        if (StringUtils.isNotEmpty(preaviso.getPromotores_desc())){
        	W83bClsTrazas.trazaError(null, "preaviso.getPromotores_desc()-> "+preaviso.getPromotores_desc(),null);
        	 String [] descPromotores=preaviso.getPromotores_desc().split(",");
             String [] desc=null;
             rowTemp = sheet.getRow((short)19);
             for (int i=0;i<descPromotores.length;i++){
             	desc=descPromotores[i].split("@");
             	row = sheet.createRow((short)++numlinea); 
             	sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));//NOPMD
                 cell = row.createCell((short)1); 
                 valor = W83bUtilidadesExcel.mayusculasCampoExcel(desc[0]);
                 cell.setCellValue(desc[1] + "-" + valor);
                 cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
                 cell = row.createCell((short)5); 
                 cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
             }
             
             rowTemp = sheet.getRow((short)20);
             cell = row.getCell((short)1); 
             cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
             cell = row.createCell((short)2); 
             cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
             cell = row.createCell((short)3); 
             cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());             
             cell = row.createCell((short)4); 
             cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());  
             cell = row.createCell((short)5); 
             cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
             ++numlinea;
             tamanyoTexto = cell.getStringCellValue().length();
             if(93<tamanyoTexto){
             	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
             }
        }
        //***************FIN PROMOTORES**************************//
        
        //***************INICIO DATOS EMPRESA**************************//
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.datos_empresa",idioma));
        rowTemp = sheet.getRow((short)10);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());

        
        //Linea CIF Y nmero de centro
        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.cif",idioma)
        		+":  "+(preaviso.getCentroTrabajo().getCifnif()==null?"":preaviso.getCentroTrabajo().getCifnif()));
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
       
        row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.num_centro",idioma)
        		+":  "+(preaviso.getCentroTrabajo().getNumCentro()==null?"":preaviso.getCentroTrabajo().getNumCentro()));
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        //Lnea razn social
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel((preaviso.getCentroTrabajo().getRazonSocial()==null?"":preaviso.getCentroTrabajo().getRazonSocial()));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.tabla.razon_social",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        //Lnea cnae y nmero de trabajadores
        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.cnae",idioma)
        		+":  "+(preaviso.getCnaePreavisoOriginal()==null?"":preaviso.getCnaePreavisoOriginal()));
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
       
        row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.numTrabajadores",idioma)
        		+":  "+(preaviso.getNumtrab()==null?"":preaviso.getNumtrab()));
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());        
        
        
        
        //Lnea num. seg. social
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));
        cell = row.createCell((short)1); 
        valor = (preaviso.getTerritsegsocial()==null?"":preaviso.getTerritsegsocial())+"/"+
        	(preaviso.getNumsegsocial()==null?"":preaviso.getNumsegsocial())+"/"+
        	(preaviso.getDigcontsegsocial()==null?"":preaviso.getDigcontsegsocial());
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.segSocial",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        
        //Lnea Domicilio
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel((preaviso.getDirAlternativa()==null?"":preaviso.getDirAlternativa()));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.dir_alternativa",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        
        //Lnea cdigo postal
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.codPostal_alternativa",idioma)
        		+":  "+(preaviso.getCodPostalAlternativa()==null?"":preaviso.getCodPostalAlternativa()));
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        
        //Lnea municipio y provincia
        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(fichaDescMunicipioOriginal);
       
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.municipio",idioma)
        		+":  ");
       
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellValue(valor);
        int tamanyo = cell.getStringCellValue().length();
        
        if(17<tamanyo){
        	row.setHeightInPoints((short)(25*(tamanyo/17)+1));
        }
        
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        HSSFCellStyle estilo =  rowTemp.getCell((short)2).getCellStyle();
        estilo.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
        cell.setCellStyle(estilo);
       
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        
        row = sheet.getRow((short)numlinea); 
        cell = row.createCell((short)4); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel(fichaDescProvinciaOriginal);
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.provincia",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        //Lnea telefono y Fax
        rowTemp = sheet.getRow((short)11);
        row = sheet.createRow((short)++numlinea); 
        cell = row.createCell((short)1); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.telefono",idioma)
        		+":  "+(preaviso.getTelefonoPreavisoOriginal()==null?"":preaviso.getTelefonoPreavisoOriginal()));
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
       
        row = sheet.createRow((short)numlinea); 
        cell = row.createCell((short)4); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.fax",idioma)
        		+":  "+(preaviso.getFaxPreavisoOriginal()==null?"":preaviso.getFaxPreavisoOriginal()));
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());   
        
        //Lnea email
        rowTemp = sheet.getRow((short)20);
        row = sheet.createRow((short)++numlinea); 
        sheet.addMergedRegion(new Region(numlinea,Short.parseShort("1"),numlinea,Short.parseShort("5")));
        cell = row.createCell((short)1); 
        valor = W83bUtilidadesExcel.mayusculasCampoExcel((preaviso.getEmailPreavisoOriginal()==null?"":preaviso.getEmailPreavisoOriginal()));
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.email",idioma)
        		+":  "+valor);
        cell.setCellStyle(rowTemp.getCell((short)1).getCellStyle());
        cell = row.createCell((short)2); 
        cell.setCellStyle(rowTemp.getCell((short)2).getCellStyle());
        cell = row.createCell((short)3); 
        cell.setCellStyle(rowTemp.getCell((short)3).getCellStyle());
        cell = row.createCell((short)4); 
        cell.setCellStyle(rowTemp.getCell((short)4).getCellStyle());
     	tamanyoTexto = cell.getStringCellValue().length();
        if(93<tamanyoTexto){
        	row.setHeightInPoints((short)(22*(tamanyoTexto/93)+1));
        }
        cell = row.createCell((short)5); 
        cell.setCellStyle(rowTemp.getCell((short)5).getCellStyle());
        
        ++numlinea;

        
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=fichaPreavisoOriginal.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}

}

